// Copyright (c) 1996 David Drysdale.  See license.txt for license info
import java.applet.*;
import java.awt.*;
import java.util.Random;
import java.lang.Math;
/*
 *
 * Tesserax
 *
 */
public class Tesserax extends Applet
{
    HexBoard gameboard;
    Button startButton;
    HexCanvas hexCanvas;
    Thread hexThread;

    int norows = 6;
    int nocols = 8;
    short size = 40;
    int nostart = 10;
    int nolock = 20;
    long timeout = 6000;

    public String[][] getParameterInfo() {
        String[][] info = {
            {"norows", "integer", "number of rows of hexes"},
            {"nocols", "integer", "number of columns of hexes"},
        };
        return info;
    }

    public String getAppletInfo() {
        return "Tesserax v1.1 (c) David Drysdale 1996-2000";
    }

    public void init() {
        int i;
        short tsz = 0;
        int row = 0;
        int col = 0;
        String s;
        Random r = new Random();
        boolean failed = false;
        Dimension d = new Dimension();

        // read in parameters
        s = this.getParameter("norows");
        try { row = Integer.parseInt(s); }
        catch (NumberFormatException e) { failed = true;}
        if (!failed) {
          norows = row;
        }

        failed = false;
        s = this.getParameter("nocols");
        try { col = Integer.parseInt(s); }
        catch (NumberFormatException e) { failed = true;}
        if (!failed) {
          nocols = col;
        }

	// find out the size of the hex
	d = size();
	size = (short) Math.min((float) d.width / (float)(nocols+1),
                                (float) d.height * 2.0 * 1.732050808 /
                                        (3.0*(float)(norows+1)) );

        gameboard = new HexBoard(norows, nocols, size, timeout, Color.green);

        // Set up the applet layout
        startButton = new Button("Start");
        this.add(startButton);

        hexCanvas = new HexCanvas(gameboard);
        hexCanvas.setSize(d.width - startButton.size().width, 
                          d.height - startButton.size().height); 
        hexThread = new Thread(hexCanvas);
        this.add(hexCanvas, -1);

    }

    // do nothing on start() . . need to press button to begin
    public boolean action(Event e, Object what) {
        boolean processed = false;
        if (e.target == startButton) {
            // green = final color
            Random r = new Random();
            int i;
            int row = 0;
            int col = 0;

            gameboard.clearBoard();
            // set some cells at random
            for (i=0; i<nostart; i++) {
                row = (int)(r.nextFloat()*(float)norows);
                col = (int)(r.nextFloat()*(float)nocols);
                gameboard.setEntry(row, col);
            }
            
            // lock some cells at random
            for (i=0; i<nolock; i++) {
                row = (int)(r.nextFloat()*(float)norows);
                col = (int)(r.nextFloat()*(float)nocols);
                gameboard.lockEntry(row, col);
            }

            // if there is an already running game thread, stop it
            hexThread.stop();

            // start the game thread, which loops round re-displaying
            // the board
            hexThread = new Thread(hexCanvas);
            hexThread.start();
            processed = true;
        } else if (e.target == hexCanvas) {
            if (e.id == Event.MOUSE_DOWN) {
                processed = hexCanvas.mouseDown(e, e.x, e.y);
            }
        }
        return(processed);
    }

    // On applet stop, make sure that the game thread is stopped too
    public void stop() {
        hexThread.stop();
    }
}
