// Copyright (c) 1996 David Drysdale.  See license.txt for license info
import java.util.Date;
import java.awt.Polygon;
import java.awt.Graphics;
import java.awt.Color;


/*
 *
 * HexCell
 *
 */
class HexCell 
{
    public static final short EMPTY = -1;
    public static final short JUSTSET = 1;
    public static final short SETFOREVER = 2;
    static short        size;
    public static short side;
    public static long  timeout;
    short               state;
    long                time_set;
    int                 x;
    int                 y;
    static int          maxRed;
    static int          maxGreen;
    static int          maxBlue;
    static int          minRed;
    static int          minGreen;
    static int          minBlue;
    static Color        finalColor;
    Polygon             hex;
    Polygon             hexo;

    public HexCell(int initx, int inity) {
        state      = EMPTY;
        x          = initx;
        y          = inity;
        hex        = new Polygon();
        hexo       = new Polygon();

        // pre-build the inside of hex polygon
        hex.addPoint(x + 1,          y + (side/2));
        hex.addPoint(x + 1,          y + (3*side/2));
        hex.addPoint(x + (size/2),   y + (2*side) - 1);
        hex.addPoint(x + size - 1,   y + (3*side/2));
        hex.addPoint(x + size - 1,   y + (side/2));
        hex.addPoint(x + (size/2),   y + 1);

        // pre-build the outside of hex polygon
        hexo.addPoint(x,              y + (side/2));
        hexo.addPoint(x,              y + (3*side/2));
        hexo.addPoint(x + (size/2),   y + (2*side));
        hexo.addPoint(x + size,       y + (3*side/2));
        hexo.addPoint(x + size,       y + (side/2));
        hexo.addPoint(x + (size/2),   y);
    }
    static public void setSize (short sz) {
        size = sz;
        side = (short) ((float) size / 1.732050808);
    }
    static public void setTimeout (long t) {
        timeout = t;
    }
    static public void setColor (Color c) {
        finalColor = c;
        maxRed     = finalColor.getRed();
        maxGreen   = finalColor.getGreen();
        maxBlue    = finalColor.getBlue();
        minRed     = maxRed / 3;
        minGreen   = maxGreen / 3;
        minBlue    = maxBlue / 3;
    }

    public void setCell () {
        Date now = new Date();
        state = JUSTSET;
        time_set = now.getTime();
    }

    public void lockCell () {
        state = SETFOREVER;
        time_set = 0;
    }

    public long whenSet () {
        return(time_set);
    }

    public short getState () {
        return(state);
    }

    public void drawCell(Graphics g) {
        Color c;

        // draw the content of the hex
        c = findColor();
        g.setColor(c);
        g.fillPolygon(hex);

        // draw the outline of the hexagon
        g.setColor(Color.white);
        g.drawPolygon(hex);
    }

    public Color findColor() {
        Date now = new Date();
        long time_now;

        if (state == EMPTY) {
            return(Color.black);
        } else if (state == SETFOREVER) {
            return(Color.blue);
        } else {
            time_now = now.getTime();
            if (time_now > time_set + timeout) {
                state = SETFOREVER;
                return(Color.blue);
            } else {
                // workout the color for this instant in time
                Color retCol = new Color(
                (int)(minRed   + (time_now-time_set)*(maxRed-minRed)/timeout),
                (int)(minGreen + (time_now-time_set)*(maxGreen-minGreen)/timeout),
                (int)(minBlue  + (time_now-time_set)*(maxBlue-minBlue)/timeout));
                return(retCol);
            }
        }
    }
    public boolean hitTest(int x, int y) {
        return(hex.inside(x, y));
    }

}

