// Copyright (c) 1996 David Drysdale.  See license.txt for license info
import java.awt.*;

/*
 * HexCanvas - extends Canvas to allow drawing of the board
 *           - also implements Runnable to allow this to be a Thread
 */
public class HexCanvas extends Canvas implements Runnable
{
    private Font font;
    private HexBoard gameboard;
    int fontsize = 48;
    int msgx = 20;
    int msgy = 75;
    boolean running = false;
    boolean hadagame = false;

    public HexCanvas(HexBoard theBoard) {
        gameboard = theBoard;
        font = new Font("Helvetica", Font.BOLD, fontsize);
    }

    // this thread loops around re-displaying the board every
    // 200ms until the game is over
    public void run() {
        running = true;
        hadagame = true;
        while (true) {
            paint(this.getGraphics());
            if (gameboard.gameWon()) {
                break;
            }
            if (gameboard.gameLost()) {
                break;
            }
            try { Thread.sleep(200); } catch (InterruptedException e) {};
        }
        running = false;
    }

    public boolean mouseDown(Event e, int x, int y) {
        if (running) {
            gameboard.mouseDown(x, y);
            return true;
        }
        return false;
    }

    // Display the board
    public void paint(Graphics g) {
        gameboard.displayBoard(g);
        if (hadagame) {
            if (gameboard.gameWon()) {
                gameWon(this.getGraphics());
            }
            if (gameboard.gameLost()) {
                gameLost(this.getGraphics());
            }
        }
    }

    void gameWon(Graphics g) {
        g.setColor(Color.red);
        g.setFont(font);
        g.drawString("You Won!", msgx, msgy);
    }

    void gameLost(Graphics g) {
        g.setColor(Color.red);
        g.setFont(font);
        g.drawString("Game Over", msgx, msgy);
    }
}
