// Copyright (c) 1996 David Drysdale.  See license.txt for license info
import java.awt.Graphics;
import java.awt.Color;
/*
 *
 * HexBoard
 *
 */
class HexBoard 
{

    int     number_left;
    int     norows;
    int     width;
    short   size;
    HexCell[][] cell_array;

    public HexBoard(int nr, int w, short sz, long tm, Color c) {
        norows = nr;
        width  = w;
        number_left = norows * width;
        size = sz;
        cell_array = new HexCell[nr][w];
        HexCell.setSize(sz);
        HexCell.setTimeout(tm);
        HexCell.setColor(c);
        clearBoard();
    }

    public void clearBoard() {
        number_left = norows*width;
        for (int row = 0; row < norows; row++) {
            for (int col = 0; col < width; col++) {
                // Initialize the array, giving each cell
                // its position
                if ( (row%2) == 0) {
                    cell_array[row][col] = new HexCell(col*size,
                                                   row * (3*HexCell.side/2));
                } else {
                    cell_array[row][col] = new HexCell(col*size + size/2,
                                                   row * (3*HexCell.side/2));
                }
            }
        }
    }

    public void setEntry(int r, int c) {
        if ((r<norows) && (c<width)) {
            if (cell_array[r][c].getState() == HexCell.EMPTY) {
                cell_array[r][c].setCell();
                number_left--;
            }
        }
    }

    public void lockEntry(int r, int c) {
        if ((r<norows) && (c<width)) {
            if (cell_array[r][c].getState() == HexCell.EMPTY) {
                cell_array[r][c].lockCell();
                number_left--;
            }
        }
    }

    void displayBoard(Graphics g) {
        int row;
        int col;
        for (row = 0; row < norows; row++) {
            for (col = 0; col < width; col++) {
                cell_array[row][col].drawCell(g);
            }
        }
    }

    void mouseDown(int x, int y) {
        int row;
        int col;
        for (row = 0; row < norows; row++) {
            for (col = 0; col < width; col++) {
                if (cell_array[row][col].hitTest(x, y)) {
                    // The mouse click is in this cell
                    if (cell_array[row][col].getState() == HexCell.EMPTY) {
                        hitCell(row, col);
                        return;
                    }
                }
            }
        }
    }

    void hitCell(int row, int col) {
        // check to see if any of the neighbours are set
        // The neighbours of a cell (x,y) are:
        //   (x,y+1) (x,y-1)     \
        //   (x-1,y) (x-1,y+1)   | if x is odd
        //   (x+1,y) (x+1,y+1)   /
        //
        //   (x,y+1) (x,y-1)     \
        //   (x-1,y) (x-1,y-1)   | if x is even
        //   (x+1,y) (x+1,y-1)   /

        if ((row%2) != 0) {
            if ((       (col>0)                     &&
                 (cell_array[row][col-1].getState() == HexCell.JUSTSET)) ||
                (     (col<(width-1))               &&
                 (cell_array[row][col+1].getState() == HexCell.JUSTSET)) ||
                ( (row>0)                           &&
                 (cell_array[row-1][col].getState() == HexCell.JUSTSET)) ||
                ( (row>0)&& (col<(width-1))         &&
                 (cell_array[row-1][col+1].getState() == HexCell.JUSTSET)) ||
                ( (row<(norows-1))                  &&
                 (cell_array[row+1][col].getState() == HexCell.JUSTSET)) ||
                ( (row<(norows-1))&&(col<(width-1)) &&
                 (cell_array[row+1][col+1].getState() == HexCell.JUSTSET)) ) {
                cell_array[row][col].setCell();
                number_left--;
            }
        } else {
            if ((       (col>0)             &&
                 (cell_array[row][col-1].getState() == HexCell.JUSTSET)) ||
                (     (col<(width-1))       &&
                 (cell_array[row][col+1].getState() == HexCell.JUSTSET)) ||
                ( (row>0)                   &&
                 (cell_array[row-1][col].getState() == HexCell.JUSTSET)) ||
                ( (row>0)&& (col>0)         &&
                 (cell_array[row-1][col-1].getState() == HexCell.JUSTSET)) ||
                ( (row<(norows-1))          &&
                 (cell_array[row+1][col].getState() == HexCell.JUSTSET)) ||
                ( (row<(norows-1))&&(col>0) &&
                 (cell_array[row+1][col-1].getState() == HexCell.JUSTSET)) ) {
                cell_array[row][col].setCell();
                number_left--;
            }
        }
    }

    boolean gameWon() {
        return(number_left==0);
    }

    boolean gameLost() {
        int row;
        int col;
        for (row = 0; row < norows; row++) {
            for (col = 0; col < width; col++) {
                if (cell_array[row][col].getState() == HexCell.JUSTSET) {
                    return(false);
                }
            }
        }
        return(true);
    }

}

